--The scripts should always contain at least 10 functions :ScriptID, DisplaySourceName(), SourceSuperClassID(), SourceClassID(), DisplayDestinationName() DestinationSuperClassID(), DestinationClassID(), AboutText() and DefaultConversion, Conversion taking a param.
--Script ID that will append to destination

fn ScriptID = 
(
    ""
)

--Return the name to be display for the source in the Scene Converter UI
fn DisplaySourceName =
(
    ~VRAY_MATERIAL~
)

--Returns the source class of the super class id 
fn SourceSuperClassID =
(
    3072 --Material
)
--Returns the class id of the source class we use as a source for conversion
fn SourceClassID =
(
    #(935280431L, 1882483036L)
)

--Return the name to be display for the destination in the Scene Converter UI - must be in the order than the destination class ids
fn DisplayDestinationName =
(
    ~PHYSICAL_MATERIAL~
)

--Returns the destination class of the super class id
fn DestinationSuperClassID =
(
    3072 --Material
)

--Returns the class id of the class we use as a destination for conversion
-- so we convert from SourceClassID() to DestinationClassID()
fn DestinationClassID =
(
    #(1030429932L, 3735928833L) --Physical Material
)

--Validate that the source provided match with one of the SourceClass
fn VerifySource source =
( 
    local ret = false
    local src = SourceClassID()

    if(source == undefined) do return false

    if(classof src[1] == Array) then
    (
        for cd in src do
        (
            if((cd as string) == (source.ClassID as string)) do
            (
                ret = true
            )
        )
    )
    else
    (
        if((src as string) == (source.ClassID as string)) do
        (
            ret = true
        )
    )
)

--Validate that the destination provided match with one of the DestinationClass
fn VerifyDestination destination =
(
    local ret = false	
    local dest = DestinationClassID()

    if(destination == undefined) do return false

    if(classof dest[1] == Array) then
    (
        for cd in dest do
        (
            if((cd as string) == (destination.ClassID as string)) do
            (
                ret = true
            )
        )
    )
    else
    (
        if((dest as string) == (destination.ClassID as string)) do
        (
            ret = true
        )
    )
    ret 
)

--Returns some information about this conversion script
fn AboutText =
(
    ~ABOUT_TEXT~
)

fn AddClamping src =
(
    if (src != undefined) then
    (
        local o = Output()
        o.map1 = src
        o.output.clamp = true
        o
    )
    else
        undefined
)

fn getPropertyValue source prop =
(
	local ret = undefined
    ret = getProperty source prop
	ret
)

--Internal function that does the parameter mapping
fn ConvertFrom_vRayMatToPhysicalMat source dest =
(
    if ( false == VerifySource Source or 
         false == VerifyDestination Dest
        ) do
    (
        --Not the suitable nodes
        return undefined
    )

    dest.base_weight           =    1.0
    local diffuse = getPropertyValue source "diffuse"
    dest.base_color            =    diffuse              -- Diffuse color

    if ((IsProperty diffuse "controller") and (diffuse.controller != undefined)) do (
        dest.base_color.controller = diffuse.controller
    )

    dest.base_color_map_on     =    getPropertyValue source "texmap_diffuse_on"    -- Diffuse texture On/Off
    dest.base_color_map        =    getPropertyValue source "texmap_diffuse"        -- Diffuse color map

    local diffuse_roughness        = getPropertyValue source "diffuse_roughness"   -- Diffuse roughness
    dest.diff_roughness        =  diffuse_roughness
    if((IsProperty diffuse_roughness "controller") and (diffuse_roughness.controller != undefined)) do (
        dest.diff_roughness.controller = diffuse_roughness.controller
    )

    dest.diff_rough_map_on     =  getPropertyValue source "texmap_roughness_on"    -- Diffuse roughness map on/off
    dest.diff_rough_map        =  getPropertyValue source "texmap_roughness"       -- Diffuse roughness map

    dest.brdf_mode  = true
    dest.material_mode = 1

    -- Reflection/Refraction

    local reflection = getPropertyValue source "reflection"

    dest.reflectivity          =    1.0
    dest.refl_color            =    reflection            -- Specular Color
    if((IsProperty reflection "controller") and (reflection.controller != undefined)) do (
        dest.refl_color.controller = reflection.controller
    )

    dest.refl_color_map        =    getPropertyValue source "texmap_reflection"    -- Specular color texture
    dest.refl_color_map_on     =    getPropertyValue source "texmap_reflection_on"  -- Specular color texture On/Off

    local reflection_lockIOR = getPropertyValue source "reflection_lockIOR"
    if(reflection_lockIOR) then
    (
        dest.trans_ior          =  getPropertyValue source "refraction_ior"
        dest.trans_ior_map_on   =  getPropertyValue source "texmap_refractionIOR_on"
        dest.trans_ior_map      =  getPropertyValue source "texmap_refractionIOR"
    )
    else
    (
        dest.trans_ior          =  getPropertyValue source "reflection_ior"
        dest.trans_ior_map_on   =  getPropertyValue source "texmap_reflectionIOR_on"
        dest.trans_ior_map      =  getPropertyValue source "texmap_reflectionIOR"
    )

    local reflection_fresnel = getPropertyValue source "reflection_fresnel"
    if(reflection_fresnel == false) then
    (
       dest.trans_ior          =  50.0        -- Sets the IOR to its max value
    )

    dest.roughness             =    getPropertyValue source "reflection_glossiness"            -- Specular Roughness
    dest.roughness_inv         =    true

    dest.roughness_map         =  getPropertyValue source "texmap_reflectionGlossiness"       -- Specular Roughness map
    dest.roughness_map_on      =  getPropertyValue source "texmap_reflectionGlossiness_on"     -- Specular Roughness map On/Off

    dest.metalness              = getPropertyValue source "reflection_metalness"

    -- Refraction
    local refraction_color = getPropertyValue source "refraction"

    if (refraction_color != (color 0 0 0)) then
    (       
        local refraction_fogMult = getPropertyValue source "refraction_fogMult"
        if(refraction_fogMult != 0.0) do
        (
            local refraction_fogColor = getPropertyValue source "refraction_fogColor"

            local fog_weight_r = (refraction_fogColor.r / 255.0) * (1.0/refraction_fogMult)
            local fog_weight_g = (refraction_fogColor.g / 255.0) * (1.0/refraction_fogMult)
            local fog_weight_b = (refraction_fogColor.b / 255.0) * (1.0/refraction_fogMult)

            local max_fog_weight  = fog_weight_r
            if (fog_weight_g > max_fog_weight) do  max_fog_weight =  fog_weight_g
            if (fog_weight_b > max_fog_weight) do  max_fog_weight =  fog_weight_b

            if(max_fog_weight > 1.0) do
            (
               fog_weight_r /= max_fog_weight
               fog_weight_g /= max_fog_weight
               fog_weight_b /= max_fog_weight
            )
    
            if(refraction_fogColor.r != 255) do
            (  
                local weight_r = (refraction.r/255.0) * fog_weight_r
                refraction_color.r *= weight_r
            )
            
            if(refraction_fogColor.g != 255) do
            (
               local weight_g = (refraction.g/255.0) * fog_weight_g
               refraction_color.g *= weight_g
            )
            
            if(refraction_fogColor.b != 255) do
            (   
               local weight_b = (refraction.b/255.0) * fog_weight_b
               refraction_color.b *= weight_b
            )

            dest.trans_depth = 1.0/refraction_fogMult
        )
        
        dest.trans_color = refraction_color

        if((IsProperty refraction_color "controller") and (refraction_color.controller != undefined)) do (
            dest.trans_color.controller = refraction_color.controller 
        )
    
        local refraction_weight = refraction_color.r
        if (refraction_color.g > refraction_weight) do refraction_weight = refraction_color.g
        if (refraction_color.b > refraction_weight) do refraction_weight = refraction_color.b
        dest.transparency = refraction_weight / 255

        -- SubSurface Scattering
        local translucency_on = getPropertyValue source "translucency_on"
        if(translucency_on != 0) do
        (
            dest.scattering      =   1 - dest.transparency
   
            local translucency_multiplier = getPropertyValue source "translucency_multiplier"
            local translucency_color = getPropertyValue source "translucency_color"

            local color_r = translucency_multiplier * translucency_color.r
            local color_g = translucency_multiplier * translucency_color.g
            local color_b = translucency_multiplier * translucency_color.b

            local max_weight  = color_r
            if (color_g > max_weight) do  max_weight =  color_g
            if (color_b > max_weight) do  max_weight =  color_b

            if(max_weight > 255) then 
            (
                dest.sss_color.r     =   color_r / max_weight * 255
                dest.sss_color.g     =   color_g / max_weight * 255
                dest.sss_color.b     =   color_b / max_weight * 255
            )
            else
            (
                dest.sss_color.r     =   color_r
                dest.sss_color.g     =   color_g
                dest.sss_color.b     =   color_b
            )

            local texmap_translucent = getPropertyValue source "texmap_translucent"
            if(texmap_translucent != undefined) do
            (
                local remap = OSLMap()
                remap.oslcode = "shader remap ( color In = 0.0, float translucency_multiplier = 1.0, output color Out = 0.0 ) { Out = In * translucency_multiplier; }"

                remap.In_map                   =  getPropertyValue source "texmap_translucent"
                remap.translucency_multiplier  =  getPropertyValue source "translucency_multiplier"
                dest.sss_color_map             =  remap                                           
                dest.sss_color_map_on          =  getPropertyValue source "texmap_translucent_on"
            )
        )
    )
    else
    (
       dest.transparency = 0.0
    )

    dest.trans_roughness      =  getPropertyValue source "refraction_glossiness"
    dest.trans_roughness_inv  =  true
    dest.trans_roughness_lock =  false

    dest.trans_color_map      =  getPropertyValue source "texmap_refraction"
    dest.trans_color_map_on   =  getPropertyValue source "texmap_refraction_on"

    dest.trans_rough_map      =  getPropertyValue source "texmap_refractionGlossiness"
    dest.trans_rough_map_on   =  getPropertyValue source "texmap_refractionGlossiness_on"

    -- Converts metalnees map
    dest.metalness_map     =  getPropertyValue source "texmap_metalness"
    dest.metalness_map_on  =  getPropertyValue source "texmap_metalness_on"

    -- Converts bump map
    dest.bump_map_on          =  getPropertyValue source "texmap_bump_on"
    dest.bump_map             =  getPropertyValue source "texmap_bump"
    dest.bump_map_amt         =  getPropertyValue source "texmap_bump_multiplier" / 100.0

    -- Converts displacement map
    dest.displacement_map_on  =  getPropertyValue source "texmap_displacement_on"
    dest.displacement_map     =  getPropertyValue source "texmap_displacement"
    dest.displacement_map_amt =  getPropertyValue source "texmap_displacement_multiplier" / 100.0

    -- Converts opacity map
    dest.cutout_map        =  getPropertyValue source "texmap_opacity"
    dest.cutout_map_on     =  getPropertyValue source "texmap_opacity_on"

    -- Emission 
    dest.emit_color           =  getPropertyValue source "selfIllumination"
    dest.emission             =  1.0

    local selfIllumination = getPropertyValue source "selfIllumination"
    if((IsProperty selfIllumination "controller") and (selfIllumination.controller != undefined)) do (
        dest.emit_color.controller = selfIllumination.controller
    )
    (
        local physical_scale = 1500
        local compensate_camera_exposure = getPropertyValue source "compensate_camera_exposure"
       if(compensate_camera_exposure) do
       (
           local p = SceneExposureControl.exposureControl

           if p != undefined do 
           (
              physical_scale = p.physical_scale
           )

           dest.emit_luminance = getPropertyValue source "selfIllumination_multiplier" / 3.1415 * physical_scale
      )
    )

    dest.emit_color_map        =  getPropertyValue source "texmap_self_illumination"
    dest.emit_color_map_on     =  getPropertyValue source "texmap_self_illumination_on"

    -- Anisotropy
    local anisotropy = getPropertyValue source "anisotropy"
    if(anisotropy == 0.0) then
    (
       dest.anisotropy          =  1.0
    )
    else
    (
       dest.anisotropy          =  pow anisotropy 4.0               -- The power factor 4 is not working for all cases, so we may need to manually adjust 	   
       dest.anisotropy          =  abs dest.anisotropy            -- the anisotropy value after conversion
    )

    if((IsProperty anisotropy "controller") and (anisotropy.controller != undefined)) do (
        dest.anisotropy.controller = anisotropy.controller
    )
    
    local anisotropy_rotation = getPropertyValue source "anisotropy_rotation"
    dest.anisoangle          =  abs(anisotropy_rotation / 360.0)
    if(anisotropy < 0.0) do
    (
        local rotation_angle     =  dest.anisoangle + 0.25
        dest.anisoangle          =  mod rotation_angle 1.0
    )

    if((IsProperty anisotropy_rotation "controller") and (anisotropy_rotation.controller != undefined)) do (
        dest.anisoangle.controller = anisotropy_rotation.controller
    )

    dest.aniso_mode = getPropertyValue source "anisotropy_derivation"
    dest.aniso_channel = getPropertyValue source "anisotropy_channel"

    local texmap_anisotropy = getPropertyValue source "texmap_anisotropy"
    if (texmap_anisotropy != undefined) do
    (
        local remap = OSLMap()
        remap.oslcode = "shader remap ( color In = 0.0, output color Out = 0.0 ) { Out = pow(In, 4.0); }"

        remap.In_map             =  texmap_anisotropy
        dest.anisotropy_map      =  remap
        dest.anisotropy_map_on   =  getPropertyValue source "texmap_anisotropy_on"
    )

    local texmap_anisotropy_rotation = getPropertyValue source "texmap_anisotropy_rotation"
    if (texmap_anisotropy_rotation != undefined) do
    (
        local remap = OSLMap()
        remap.oslcode = "shader remap ( color In = 0.0, output color Out = 0.0 ) { Out = 1.0 - In; }"

        remap.In_map             =  texmap_anisotropy_rotation
        dest.aniso_angle_map     =  remap
        dest.aniso_angle_map_on  =  getPropertyValue source "texmap_anisotropy_rotation_on"
    )

    dest
)

--This function is use as entry when the source is missing (due to a missing plugin) and cannot be completly loaded. 
--In that case a default object is created and returned.
fn DefaultConversion source /*Not use*/=
(
    --Create the dest material
    newMat = PhysicalMaterial()

    --return the new material
    newMat

)

--Main entry point from this script
--This function handles the material's creation
fn Conversion vRayMtl =
(
    if (false == VerifySource vRayMtl )  do
    (
        --Not the suitable node
        return undefined
    )
    
    --Create the dest material
    newMat = PhysicalMaterial()
    
    --Call the parameters mapping function to convert
    ConvertFrom_vRayMatToPhysicalMat vRayMtl newMat

    if (IsProperty vRayMtl "name") and (undefined != vRayMtl.name) and (String == classof vRayMtl.name)  and (IsProperty newMat "name") do
    (
        newMat.name = vRayMtl.name
    )

    --return the new material
    newMat
)
